// background.js (Chromium MV3)
let state = {
  enabled: false,
  mode: 'manual',
  manual: { scheme:'http', host:'', port:0, username:'', password:'', bypassList:['<local>'] },
  _proxyList: [],
  _currentProxy: null,
  apiBase: '',
  token: '',
  tabProxies: {}
};

async function save() { await chrome.storage.local.set({ state }); }
async function load() { const s = (await chrome.storage.local.get('state')).state; if (s) state = s; }

function buildProxyConfig(p){
  if (!p || !state.enabled) return { mode:'direct' };
  const rules = {
    singleProxy: { scheme: p.scheme || 'http', host: p.host, port: Number(p.port)||0 },
    bypassList: Array.isArray(p.bypassList) ? p.bypassList : ['<local>']
  };
  return { mode: 'fixed_servers', rules };
}

async function applyNow(){
  try {
    const p = state._currentProxy || state.manual;
    await chrome.proxy.settings.set({ value: buildProxyConfig(p), scope: 'regular' });
    return { ok: true };
  } catch (e) {
    return { ok:false, error: String(e) };
  }
}

try {
  if (chrome.webRequest && chrome.webRequest.onAuthRequired) {
    chrome.webRequest.onAuthRequired.addListener(
      (details, cb) => {
        const p = state._currentProxy || state.manual;
        if (state.enabled && p && p.username) {
          cb({ authCredentials: { username: p.username, password: p.password || '' } });
        } else {
          cb({});
        }
      },
      { urls: ["<all_urls>"] },
      ["asyncBlocking"]
    );
  }
} catch (e) {}

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  (async () => {
    if (msg.type === 'getConfig') { await load(); sendResponse({ config: state }); return; }
    if (msg.type === 'setConfig') { await load(); state = { ...state, ...msg.config };
      if (msg.config.manual) state._currentProxy = msg.config.manual; await save(); sendResponse({ ok:true }); return; }
    if (msg.type === 'applyConfigNow') { await load(); const r = await applyNow(); sendResponse(r); return; }
    if (msg.type === 'applyProxyToTab') { await load(); state.enabled = true; state.tabProxies[String(msg.tabId)] = msg.proxy; state._currentProxy = msg.proxy; await save(); const r = await applyNow(); sendResponse(r); return; }
  })();
  return true;
});
